// More information about this indicator can be found at:
// http://fxcodebase.com/code/viewtopic.php?f=38&t=68338

//+------------------------------------------------------------------+
//|                               Copyright © 2019, Gehtsoft USA LLC | 
//|                                            http://fxcodebase.com |
//+------------------------------------------------------------------+
//|                                      Developed by : Mario Jemic  |
//|                                          mario.jemic@gmail.com   |
//+------------------------------------------------------------------+
//|                                 Support our efforts by donating  |
//|                                  Paypal : https://goo.gl/9Rj74e  |
//+------------------------------------------------------------------+
//|                                Patreon :  https://goo.gl/GdXWeN  |
//+------------------------------------------------------------------+
// modified by banzai from Mario Jemic template 
// July 25th, 2020
// not for sale, rent, auction, nor lease
    //+------------------------------------------------------------------+
    //|                                                       SupDem.mq4 |
    //+------------------------------------------------------------------+  

    #property indicator_chart_window
    #property indicator_buffers 2
    extern int Forced_TimeFrame = 0;
    extern bool use_narrow_bands = false;
    extern bool kill_retouch = true;
    extern color TopColor = clrCrimson;
    extern color BotColor = clrDarkGreen;
    extern color Price_mark = clrDimGray;
    extern int Price_Width = 1;
    extern bool Rectangle_fill = 0;
    extern int Rectangle_border_width = 0;

extern string             button_note1          = "------------------------------";
extern ENUM_BASE_CORNER   btn_corner            = CORNER_LEFT_UPPER; // chart btn_corner for anchoring
extern string             btn_text              = "M5 SupDemB";
extern string             btn_Font              = "Arial";
extern int                btn_FontSize          = 8;                             //btn__font size
extern color              btn_text_color        = clrWhite;
extern color              btn_background_color  = clrDimGray;
extern color              btn_border_color      = clrBlack;
extern int                button_x              = 20;                                     //btn__x
extern int                button_y              = 13;                                     //btn__y
extern int                btn_Width             = 80;                                 //btn__width
extern int                btn_Height            = 20;                                //btn__height
extern string             button_note2          = "------------------------------";

bool                      show_data             = true;
string IndicatorName, IndicatorObjPrefix;
//template code end1
    double BuferUp[], BuferDn[], iPeriod=13, p1, p2, point,up_cur,dn_cur;
    int Dev=8, Step=5, digits, tf;
    datetime t1,t2;
    string pair, TAG;
//+------------------------------------------------------------------+
string GenerateIndicatorName(const string target) //don't change anything here
{
   string name = target;
   int try = 2;
   while (WindowFind(name) != -1)
   {
      name = target + " #" + IntegerToString(try++);
   }
   return name;
}
//+------------------------------------------------------------------+
string buttonId;

//+------------------------------------------------------------------+
int init()
{
   IndicatorName = GenerateIndicatorName(btn_text);
   IndicatorObjPrefix = "__" + IndicatorName + "__";
   IndicatorShortName(IndicatorName);
   IndicatorDigits(Digits);
   
   double val;
   if (GlobalVariableGet(IndicatorName + "_visibility", val))
      show_data = val != 0;

// put init() here
       SetIndexBuffer(1,BuferUp);
       SetIndexEmptyValue(1,0.0);
       SetIndexStyle(1,DRAW_NONE);
       SetIndexBuffer(0,BuferDn);
       SetIndexEmptyValue(0,0.0);
       SetIndexStyle(0,DRAW_NONE);
       if(Forced_TimeFrame != 0) tf = Forced_TimeFrame;
          else tf = Period();
       point = Point;
       digits = Digits;
       if(digits == 3 || digits == 5) point*=10;
       ObDeleteAll();
       TAG = "Box_SupDem"+tf;

   ChartSetInteger(0, CHART_EVENT_MOUSE_MOVE, 1);
   buttonId = IndicatorObjPrefix + "BoxSupDem";
   createButton(buttonId, btn_text, btn_Width, btn_Height, btn_Font, btn_FontSize, btn_background_color, btn_border_color, btn_text_color);
   ObjectSetInteger(0, buttonId, OBJPROP_YDISTANCE, button_y);
   ObjectSetInteger(0, buttonId, OBJPROP_XDISTANCE, button_x);
   
   return 0;
}
//+------------------------------------------------------------------+
//don't change anything here
void createButton(string buttonID,string buttonText,int width,int height,string font,int fontSize,color bgColor,color borderColor,color txtColor)
{
      ObjectDelete    (0,buttonID);
      ObjectCreate    (0,buttonID,OBJ_BUTTON,0,0,0);
      ObjectSetInteger(0,buttonID,OBJPROP_COLOR,txtColor);
      ObjectSetInteger(0,buttonID,OBJPROP_BGCOLOR,bgColor);
      ObjectSetInteger(0,buttonID,OBJPROP_BORDER_COLOR,borderColor);
      ObjectSetInteger(0,buttonID,OBJPROP_BORDER_TYPE,BORDER_RAISED);
      ObjectSetInteger(0,buttonID,OBJPROP_XSIZE,width);
      ObjectSetInteger(0,buttonID,OBJPROP_YSIZE,height);
      ObjectSetString (0,buttonID,OBJPROP_FONT,font);
      ObjectSetString (0,buttonID,OBJPROP_TEXT,buttonText);
      ObjectSetInteger(0,buttonID,OBJPROP_FONTSIZE,fontSize);
      ObjectSetInteger(0,buttonID,OBJPROP_SELECTABLE,0);
      ObjectSetInteger(0,buttonID,OBJPROP_CORNER,btn_corner);
      ObjectSetInteger(0,buttonID,OBJPROP_HIDDEN,1);
      ObjectSetInteger(0,buttonID,OBJPROP_XDISTANCE,9999);
      ObjectSetInteger(0,buttonID,OBJPROP_YDISTANCE,9999);
}
//+------------------------------------------------------------------+
int deinit()
{
   ObjectsDeleteAll(ChartID(), IndicatorObjPrefix);

//put deinit() here
//       ObDeleteObjectsByPrefix(TAG);
       ObDeleteAll();
       Comment("");

   return 0;
}
//+------------------------------------------------------------------+
//don't change anything here
bool recalc = true;

void handleButtonClicks()
{
   if (ObjectGetInteger(0, buttonId, OBJPROP_STATE))
   {
      ObjectSetInteger(0, buttonId, OBJPROP_STATE, false);
      show_data = !show_data;
      GlobalVariableSet(IndicatorName + "_visibility", show_data ? 1.0 : 0.0);
      recalc = true;
      start();
   }
}
//+------------------------------------------------------------------+
void OnChartEvent(const int id, //don't change anything here
                  const long &lparam,
                  const double &dparam,
                  const string &sparam)
{
   handleButtonClicks();
}
//+------------------------------------------------------------------+
int start()
{
   handleButtonClicks();
   recalc = false;
       if(NewBar()==true)
       {
          CountZZ(BuferUp,BuferDn,iPeriod,Dev,Step);
          GetValid();
          Draw();
       }

      if (show_data)
      {
          CountZZ(BuferUp,BuferDn,iPeriod,Dev,Step);
          GetValid();
          Draw();
      }
      else
      {
       ObDeleteObjectsByPrefix(TAG);
       Comment("");
      }
   return 0;
}
//+------------------------------------------------------------------+
    void Draw()
    {
       int i;
       string s;
       ObDeleteObjectsByPrefix(TAG);
       for(i=0;i<iBars(pair,tf);i++)
       {
          if(BuferDn[i] > 0.0)
          {
             t1 = iTime(pair,tf,i);
             t2 = Time[0];
             if(use_narrow_bands) p2 = MathMax(iClose(pair,tf,i),iOpen(pair,tf,i));
                else p2 = MathMin(iClose(pair,tf,i),iOpen(pair,tf,i));
             p2 = MathMax(p2,MathMax(iLow(pair,tf,i-1),iLow(pair,tf,i+1)));


             s = TAG+"UPAR"+tf+i;
             ObjectCreate(s,OBJ_ARROW,0,0,0);
             ObjectSet(s,OBJPROP_ARROWCODE,SYMBOL_RIGHTPRICE);
             ObjectSet(s, OBJPROP_TIME1, t2);
             ObjectSet(s, OBJPROP_PRICE1, p2);
             ObjectSet(s,OBJPROP_COLOR,Price_mark);
             ObjectSet(s,OBJPROP_WIDTH,Price_Width);     
         
             s = TAG+"UPFILL"+tf+i;
             ObjectCreate(s,OBJ_RECTANGLE,0,0,0,0,0);
             ObjectSet(s,OBJPROP_TIME1,t1);
             ObjectSet(s,OBJPROP_PRICE1,BuferDn[i]);
             ObjectSet(s,OBJPROP_TIME2,t2);
             ObjectSet(s,OBJPROP_PRICE2,p2);
             ObjectSet(s,OBJPROP_COLOR,TopColor);
             if(Rectangle_fill == false)
             {
               ObjectSetInteger(0,s,OBJPROP_BACK,0);
               ObjectSetInteger(0,s,OBJPROP_WIDTH,Rectangle_border_width);
             }
             else if(Rectangle_fill == true)
             {
               ObjectSetInteger(0,s,OBJPROP_BACK,1);
             }
          }

          if(BuferUp[i] > 0.0)
          {
             t1 = iTime(pair,tf,i);
             t2 = Time[0];
             if(use_narrow_bands) p2 = MathMin(iClose(pair,tf,i),iOpen(pair,tf,i));
                else p2 = MathMax(iClose(pair,tf,i),iOpen(pair,tf,i));
             if(i>0) p2 = MathMin(p2,MathMin(iHigh(pair,tf,i+1),iHigh(pair,tf,i-1)));
             s = TAG+"DNAR"+tf+i;
             ObjectCreate(s,OBJ_ARROW,0,0,0);
             ObjectSet(s, OBJPROP_ARROWCODE,SYMBOL_RIGHTPRICE);
             ObjectSet(s, OBJPROP_TIME1, t2);
             ObjectSet(s, OBJPROP_PRICE1, p2);
             ObjectSet(s, OBJPROP_COLOR,Price_mark);
             ObjectSet(s, OBJPROP_WIDTH,Price_Width); 

             s = TAG+"DNFILL"+tf+i;
             ObjectCreate(s,OBJ_RECTANGLE,0,0,0,0,0);
             ObjectSet(s,OBJPROP_TIME1,t1);
             ObjectSet(s,OBJPROP_PRICE1,p2);
             ObjectSet(s,OBJPROP_TIME2,t2);
             ObjectSet(s,OBJPROP_PRICE2,BuferUp[i]);
             ObjectSet(s,OBJPROP_COLOR,BotColor);
             if(Rectangle_fill == false)
             {
               ObjectSetInteger(0,s,OBJPROP_BACK,0);
               ObjectSetInteger(0,s,OBJPROP_WIDTH,Rectangle_border_width);
             }
             else if(Rectangle_fill == true)
             {
               ObjectSetInteger(0,s,OBJPROP_BACK,1);
             }
          }
       }
    }
//+------------------------------------------------------------------+
    bool NewBar() {

       static datetime LastTime = 0;

       if (iTime(pair,tf,0) != LastTime) {
          LastTime = iTime(pair,tf,0);      
          return (true);
       } else
          return (false);
    }
//+------------------------------------------------------------------+
    void ObDeleteAll()
    {
//       int L = StringLen(Prefix);
       int i = 0;
       while(i < ObjectsTotal())
       {
          string ObjName = ObjectName(i);
          if(StringSubstr(ObjName, 0, 10) != "Box_SupDem")
          {
             i++;
             continue;
          }
          ObjectDelete(ObjName);
       }
    }
//+------------------------------------------------------------------+
    void ObDeleteObjectsByPrefix(string Prefix)
    {
       int L = StringLen(Prefix);
       int i = 0;
       while(i < ObjectsTotal())
       {
          string ObjName = ObjectName(i);
          if(StringSubstr(ObjName, 0, L) != Prefix)
          {
             i++;
             continue;
          }
          ObjectDelete(ObjName);
       }
    }
//+------------------------------------------------------------------+
    int CountZZ( double& ExtMapBuffer[], double& ExtMapBuffer2[], int ExtDepth, int ExtDeviation, int ExtBackstep )
    {
       int    shift, back,lasthighpos,lastlowpos;
       double val,res;
       double curlow,curhigh,lasthigh,lastlow;
       int count = iBars(pair,tf)-ExtDepth;

       for(shift=count; shift>=0; shift--)
         {
          val = iLow(pair,tf,iLowest(pair,tf,MODE_LOW,ExtDepth,shift));
          if(val==lastlow) val=0.0;
          else
            {
             lastlow=val;
             if((iLow(pair,tf,shift)-val)>(ExtDeviation*Point)) val=0.0;
             else
               {
                for(back=1; back<=ExtBackstep; back++)
                  {
                   res=ExtMapBuffer[shift+back];
                   if((res!=0)&&(res>val)) ExtMapBuffer[shift+back]=0.0;
                  }
               }
            }
           
              ExtMapBuffer[shift]=val;
          //--- high
          val=iHigh(pair,tf,iHighest(pair,tf,MODE_HIGH,ExtDepth,shift));
         
          if(val==lasthigh) val=0.0;
          else
            {
             lasthigh=val;
             if((val-iHigh(pair,tf,shift))>(ExtDeviation*Point)) val=0.0;
             else
               {
                for(back=1; back<=ExtBackstep; back++)
                  {
                   res=ExtMapBuffer2[shift+back];
                   if((res!=0)&&(res<val)) ExtMapBuffer2[shift+back]=0.0;
                  }
               }
            }
          ExtMapBuffer2[shift]=val;
         }
       // final cutting
       lasthigh=-1; lasthighpos=-1;
       lastlow=-1;  lastlowpos=-1;

       for(shift=count; shift>=0; shift--)
         {
          curlow=ExtMapBuffer[shift];
          curhigh=ExtMapBuffer2[shift];
          if((curlow==0)&&(curhigh==0)) continue;
          //---
          if(curhigh!=0)
            {
             if(lasthigh>0)
               {
                if(lasthigh<curhigh) ExtMapBuffer2[lasthighpos]=0;
                else ExtMapBuffer2[shift]=0;
               }
             //---
             if(lasthigh<curhigh || lasthigh<0)
               {
                lasthigh=curhigh;
                lasthighpos=shift;
               }
             lastlow=-1;
            }
          //----
          if(curlow!=0)
            {
             if(lastlow>0)
               {
                if(lastlow>curlow) ExtMapBuffer[lastlowpos]=0;
                else ExtMapBuffer[shift]=0;
               }
             //---
             if((curlow<lastlow)||(lastlow<0))
               {
                lastlow=curlow;
                lastlowpos=shift;
               }
             lasthigh=-1;
            }
         }
     
       for(shift=iBars(pair,tf)-1; shift>=0; shift--)
       {
          if(shift>=count) ExtMapBuffer[shift]=0.0;
             else
             {
                res=ExtMapBuffer2[shift];
                if(res!=0.0) ExtMapBuffer2[shift]=res;
             }
       }
    return(0);   
    }
//+------------------------------------------------------------------+
    void GetValid()
    {
       up_cur = 0;
       int upbar = 0;
       dn_cur = 0;
       int dnbar = 0;
       double cur_hi = 0;
       double cur_lo = 0;
       double last_up = 0;
       double last_dn = 0;
       double low_dn = 0;
       double hi_up = 0;
       int i;
       for(i=0;i<iBars(pair,tf);i++)
       {
          if(BuferUp[i] > 0)
          {
             up_cur = BuferUp[i];
             cur_lo = BuferUp[i];
             last_up = cur_lo;
             break;
          }
       }
       for(i=0;i<iBars(pair,tf);i++)
       {
          if(BuferDn[i] > 0)
          {
             dn_cur = BuferDn[i];
             cur_hi = BuferDn[i];
             last_dn = cur_hi;
             break;
          }
       }

       for(i=0;i<iBars(pair,tf);i++) // remove higher lows and lower highs
       {
          if(BuferDn[i] >= last_dn)
          {
             last_dn = BuferDn[i];
             dnbar = i;
          }
             else BuferDn[i] = 0.0;
         
          if(BuferDn[i] <= dn_cur && BuferUp[i] > 0.0) BuferDn[i] = 0.0;

          if(BuferUp[i] <= last_up && BuferUp[i] > 0)
          {
             last_up = BuferUp[i];
             upbar = i;
          }
             else BuferUp[i] = 0.0;
         
          if(BuferUp[i] > up_cur) BuferUp[i] = 0.0;

       }

       if(kill_retouch)
       {
          if(use_narrow_bands)
          {
             low_dn = MathMax(iOpen(pair,tf,dnbar),iClose(pair,tf,dnbar));
             hi_up = MathMin(iOpen(pair,tf,upbar),iClose(pair,tf,upbar));
          }
             else
             {
                low_dn = MathMin(iOpen(pair,tf,dnbar),iClose(pair,tf,dnbar));
                hi_up = MathMax(iOpen(pair,tf,upbar),iClose(pair,tf,upbar));         
             }

          for(i=MathMax(upbar,dnbar);i>=0;i--) // work back to zero and remove reentries into s/d
          {
             if(BuferDn[i] > low_dn && BuferDn[i] != last_dn) BuferDn[i] = 0.0;
                else if(use_narrow_bands && BuferDn[i] > 0)
                {
                   low_dn = MathMax(iOpen(pair,tf,i),iClose(pair,tf,i));
                   last_dn = BuferDn[i];
                }
                   else if(BuferDn[i] > 0)
                   {
                      low_dn = MathMin(iOpen(pair,tf,i),iClose(pair,tf,i));
                      last_dn = BuferDn[i];
                   }

             if(BuferUp[i] <= hi_up && BuferUp[i] > 0 && BuferUp[i] != last_up) BuferUp[i] = 0.0;
                else if(use_narrow_bands && BuferUp[i] > 0)
                {
                   hi_up = MathMin(iOpen(pair,tf,i),iClose(pair,tf,i));
                   last_up = BuferUp[i];
                }
                   else if(BuferUp[i] > 0)
                   {
                      hi_up = MathMax(iOpen(pair,tf,i),iClose(pair,tf,i));
                      last_up = BuferUp[i];
                   }
          }
       }
    } 
//+------------------------------------------------------------------+

